libname q 'c:\SASCodeforBook\SASDataSets';

Data First; set q.frauddata;
  /* Chapter 9, this code develops and tests the anti index
		and explores its determinants and consequences*/

sixoffices = sofice35; 
design3 = threclas;
officetypeCFRD = TESPonly;
OfficetypeM2K = V2Konly;
OfficetypeOneSys = OneSys;
OfficetypeBothSys = BothSys;
OfficetypeNoNewSys = ZeroSys;
/*The antiindex is used in the proc mixed analysis. It includes 197 data base cases	*/
antiIndex=nwanti3;
/*The crosstabulation of these two dichotomized variables creates the antiindex*/
DetectorUseful16 = NWDich16;
PeopleBetter29 = DICH29;
/* Dichotomized New Question 16, 10 missing placed in middle category prior to dichotomizing,
	1 = CFD would not be useful, 0 = CFD would be useful*/
/* Dichotomized Question 29, 1 = people detect fraud better, 0 = people not better */
run;


Data second; Set First;

Title 'Ungrouped Distributions of anti index items Q16 How useful (CFD16 NWCFD16)and
	Q29 employees detect fraud better (Wbest29)';
	Proc freq; 
	tables CFD16 NWCFD16 Wbest29; 
run;


Title 'Crosstabulation of Dichotomized Items Composing the Anti-Index';
	Proc Freq; 
	Tables DetectorUseful16 PeopleBetter29 DetectorUseful16*PeopleBetter29 AntiIndex;
run;

Title 'Mean of AntiIndex';
	Proc Means; Var AntiIndex; run; 


/*Correlation of Full Items Composing the Anti-Index and Alpha Reliability of Full Items,
please reverse the sign of the correlation and the alpha*/
	Title 'Alpha with variable CFD16 ten missing values added to middle category';
		Proc Corr Alpha NoMiss;
		var NWCFD16 wbest29;
	run; 
	Title 'Alpha with variable CFD16  missing values not added to middle category';
		Proc Corr Alpha NoMiss; 
		var CFD16 wbest29;
	run;

	
/* EspGD41 is seven point scale 11.4% favorable, 15.7% neutral, 72.9% unfavorable as reported*/
/* TriESP41 is trichotomy 11.4% favorable=1, 22.86% neutral or slightly unfavorable=2, 65.71%
		very unfavorable=3 */
/*DICH41 groups favorable + neutral as not unfavorable 0 27.4%, vs. unfavorable =1	72.86%*/
/*Trichotomy with missing = 0 never used CFRD, 1 not unfavorable, 2 unfavorable*/
Title 'Distributions of Users Evaluations of CFRD';
	Proc Freq;
	Tables TRIESP41 ESPGD41 DICH41 Hatecfrd;
Run; 

/*Usep40 is answer to "Have you ever used the Electornic Suspicion Profile (ESP=CFRD) Yes = 1
and 2 = No. REVesp40 reverses the code so that the antiindex is positively associated with it*/
Title 'Validating Correlations of AntiIndex';
	Proc Corr; var AntiIndex usesp40 REVesp40 TRIESP41 ESPGD41 DICH41 Hatecfrd;
run;

/*Target and Control Offices and the Scores on the dichotomized anti-index Dantidex
(10 missing observations not allocated)*/
Title 'Target vs. Control offices and the dichotomized anti-index';
	Proc Sort;
	by targvcon;
	Proc means; 
	var dantidex;
	by targvcon; 
run;

Title'Coleman effect parameter (OLS Regression) for Target vs. Control on dichotomized anti index.';
	proc reg;
	model dantidex = targvcon; 
	run;

Title 'Coleman effect parameter for Target vs. Control on dichotomized anti index, Philadelphia area';
data metrophily; set second;
If sites = 1; 
	Proc Sort;
	by targvcon;
	Proc means; 
	var dantidex;
	by targvcon; 
	proc reg;
	model dantidex = targvcon; 
run;
Title 'Coleman effect parameter for Target vs. Control on dichotomized anti index, Boston area';
data metroboston; set second;
if sites = 2;
Proc Sort;
	by targvcon;
	Proc means; 
	var dantidex;
	by targvcon; 
	proc reg;
	model dantidex = targvcon; 
run;

Title 'Coleman effect parameter for Target vs. Control on dichotomized anti index, Florida';
data florida; set second;
if sites = 0;
Proc Sort;
	by targvcon;
	Proc means; 
	var dantidex;
	by targvcon; 
	proc reg;
	model dantidex = targvcon; 
run;


Title 'Coleman effect parameter for Target vs. Control on dichotomized anti index, Not Florida';
data notflorida; set second;
if sites ne 0;
Proc Sort;
	by targvcon;
	Proc means; 
	var dantidex;
	by targvcon; 
	proc reg;
	model dantidex = targvcon; 
run;

Title 'Coleman effect parameter for Target Offices in Philly (=1) and Boston (=2)';
data twotargets; set notflorida;
if target= 1;
Proc Sort;
	by sixoffices;
	Proc means; 
	var dantidex;
	by sixoffices; 
	proc reg;
	model dantidex = sixoffices; 
run;

Title 'Difference between Florida target office and the other target offices';
Data threetargets; set second;
if target = 1;
Proc Sort;
	by Targflor;
	Proc means;
	var dantidex EspGD41 ;
	by targflor;
	proc reg;
	model dantidex = targflor;
	proc reg;
	model ESPGD41 = targflor;
run;

data third; set second;
Title 'For Hypothesis 1, Difference Between Types of Offices: 2 systems =4,CFRD=3, M2K =2, None =1';
	Proc Sort; by Forclass;
	Proc means; var dantidex;
	by forclass;
run;

Title 'Differences between both new systems and one new system and between no new systems';
	Proc Reg;
	model dantidex = onesys zerosys; 
run;

Title 'Difference between no new systems and one and both new systems';
	proc reg;
	model dantidex = bothsys onesys; 
run;

/*For Hypothesis 4, The Insignificant Difference between CFRD and M2K may imply that job
	insecurity is not key reason for the discontent, CFRD is refence category*/

Title'The preferred estimate of difference between M2K and FRD comes from this proc mixed model';
Proc Mixed data = first covtest ratio;
class sixoffices ;
model AntiIndex = fac1_1 fac2_1 BothSys tesponly zerosys/s;
random SixOffices / s;
run;

			/*The code ends the explorations of the antiIndex*/
			/*The syntax in this file is copyright by Robert B. Smith */
